/*
 * Decompiled with CFR 0.152.
 */
package vesso.util.mysql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import vesso.util.MyLogger;
import vesso.util.mysql.JDBCUtil;

public class MyKeepADao {
    static MyLogger _log = new MyLogger(MyLogger.Tier.MODEL);
    JDBCUtil jdbcUtil;
    Connection conn = null;
    Statement stmt = null;

    public MyKeepADao(JDBCUtil jdbcUtil) {
        this.jdbcUtil = jdbcUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpdate(String query) {
        try {
            this.conn = this.jdbcUtil.getConnection();
            this.stmt = this.conn.createStatement();
            this.stmt.executeUpdate(query);
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.stmt != null) {
                    this.conn.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
    }

    public void createTable() {
        String sqlQuery = "create table mysql_keep_alive (id INTEGER not NULL,  is_alive VARCHAR(255),  PRIMARY KEY ( id ))";
        _log.qLog("executando query: " + sqlQuery);
        this.executeUpdate(sqlQuery);
    }

    public void addRegistry() {
        _log.qLog("Inserindo registro(s) na tabela...");
        String sqlQuery = "insert into mysql_keep_alive values (1, 'Broken Pipe nunca mais!')";
        this.executeUpdate(sqlQuery);
        _log.qLog("Registro(s) inseridos com sucesso...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listRegistries() {
        ArrayList<String> registries = new ArrayList<String>();
        try {
            this.conn = this.jdbcUtil.getConnection();
            this.stmt = this.conn.createStatement();
            String sql = "SELECT id, is_alive alive FROM mysql_keep_alive";
            ResultSet rs = this.stmt.executeQuery(sql);
            while (rs.next()) {
                int id = rs.getInt("id");
                String isAlive = rs.getString("alive");
                System.out.print("ID: " + id);
                System.out.print(", Is Alive: " + isAlive);
                registries.add(isAlive);
            }
            rs.close();
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.stmt != null) {
                    this.conn.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return registries;
    }

    public boolean isTableExists(String dbName, String tableName) {
        boolean exists = false;
        for (String current : this.listDBTables(dbName)) {
            if (!current.equals(tableName)) continue;
            exists = true;
        }
        _log.qLog("A tabela " + tableName + ", do banco " + dbName + " existe? " + exists);
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listDBTables(String dbName) {
        ArrayList<String> tablesNames = new ArrayList<String>();
        try {
            this.conn = this.jdbcUtil.getConnection();
            DatabaseMetaData metaData = this.conn.getMetaData();
            ResultSet rs = metaData.getCatalogs();
            while (rs.next()) {
                String currentDB = rs.getString(1);
                if (!currentDB.equals(dbName)) continue;
                ResultSet rs2 = metaData.getTables(dbName, null, "%", null);
                while (rs2.next()) {
                    String tableName = rs2.getString(3);
                    tablesNames.add(tableName);
                }
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.stmt != null) {
                    this.conn.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return tablesNames;
    }

    public boolean isDBExists(String dbName) {
        boolean exists = false;
        for (String current : this.listDBs()) {
            if (!current.equals(dbName)) continue;
            exists = true;
        }
        _log.qLog("O banco " + dbName + " existe? " + exists);
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listDBs() {
        ArrayList<String> dbs = new ArrayList<String>();
        try {
            this.conn = this.jdbcUtil.getConnection();
            DatabaseMetaData metaData = this.conn.getMetaData();
            ResultSet rs = metaData.getCatalogs();
            while (rs.next()) {
                dbs.add(rs.getString(1));
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.stmt != null) {
                    this.conn.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return dbs;
    }
}

