/*
 * Decompiled with CFR 0.152.
 */
package vesso.model.dao;

import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.exception.JDBCConnectionException;
import vesso.model.dao.HibernateUtil;
import vesso.util.MyLogger;

public abstract class AbstractDao<T>
implements Serializable {
    protected MyLogger logger = new MyLogger(MyLogger.Tier.DATA_ACCESS);
    protected Class<T> entityClass;
    private HibernateUtil hibernate = HibernateUtil.getInstance();
    protected static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdate(T pojo) {
        Session hibernateSession = null;
        try {
            hibernateSession = this.getSession();
            Transaction transaction = hibernateSession.beginTransaction();
            hibernateSession.saveOrUpdate(pojo);
            if (!transaction.wasCommitted()) {
                transaction.commit();
            }
        }
        catch (JDBCConnectionException e) {
            e.printStackTrace();
        }
        catch (TransactionException e) {
            e.printStackTrace();
        }
        catch (HibernateException e) {
            e.printStackTrace();
        }
        finally {
            this.closeSession(hibernateSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T pojo) {
        Session hibernateSession = null;
        try {
            hibernateSession = this.getSession();
            Transaction transaction = hibernateSession.beginTransaction();
            hibernateSession.persist(pojo);
            if (!transaction.wasCommitted()) {
                transaction.commit();
            }
        }
        catch (JDBCConnectionException e) {
            e.printStackTrace();
        }
        catch (TransactionException e) {
            e.printStackTrace();
        }
        catch (HibernateException e) {
            e.printStackTrace();
        }
        finally {
            this.closeSession(hibernateSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(T pojo) {
        Session hibernateSession = null;
        try {
            hibernateSession = this.getSession();
            Transaction transaction = hibernateSession.beginTransaction();
            hibernateSession.update(pojo);
            if (!transaction.wasCommitted()) {
                transaction.commit();
            }
        }
        catch (JDBCConnectionException e) {
            e.printStackTrace();
        }
        catch (TransactionException e) {
            e.printStackTrace();
        }
        catch (HibernateException e) {
            e.printStackTrace();
        }
        finally {
            this.closeSession(hibernateSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(T pojo) {
        Session hibernateSession = null;
        try {
            hibernateSession = this.getSession();
            Transaction transaction = hibernateSession.beginTransaction();
            hibernateSession.delete(pojo);
            if (!transaction.wasCommitted()) {
                transaction.commit();
            }
        }
        catch (JDBCConnectionException e) {
            e.printStackTrace();
        }
        catch (TransactionException e) {
            e.printStackTrace();
        }
        catch (HibernateException e) {
            e.printStackTrace();
        }
        finally {
            this.closeSession(hibernateSession);
        }
    }

    public void remove(Serializable key) {
        this.remove(this.get(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(Serializable key) {
        Session hibernateSession = null;
        Object pojo = null;
        try {
            hibernateSession = this.getSession();
            pojo = hibernateSession.get(this.entityClass, key);
        }
        catch (JDBCConnectionException e) {
            e.printStackTrace();
        }
        catch (TransactionException e) {
            e.printStackTrace();
        }
        catch (HibernateException e) {
            e.printStackTrace();
        }
        finally {
            this.closeSession(hibernateSession);
        }
        return (T)pojo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(String queryPrefix, Object ... args) {
        Session hibernateSession = null;
        Object object = null;
        try {
            hibernateSession = this.getSession();
            Query query = hibernateSession.createQuery(queryPrefix);
            for (int i = 1; i <= args.length; ++i) {
                Object param = args[i - 1];
                System.out.println("@Cesarbs Logging: GenericDAO getPojoByQuery: testa parametro= " + param.toString());
                query.setParameter(i, param);
            }
            object = query.uniqueResult();
        }
        catch (JDBCConnectionException e) {
            e.printStackTrace();
        }
        catch (TransactionException e) {
            e.printStackTrace();
        }
        catch (HibernateException e) {
            e.printStackTrace();
        }
        finally {
            this.closeSession(hibernateSession);
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> list() {
        Session hibernateSession = null;
        List pojos = null;
        try {
            hibernateSession = this.getSession();
            Query query = hibernateSession.createQuery("from " + this.entityClass.getName());
            pojos = query.list();
        }
        catch (JDBCConnectionException e) {
            e.printStackTrace();
        }
        catch (TransactionException e) {
            e.printStackTrace();
        }
        catch (HibernateException e) {
            e.printStackTrace();
        }
        finally {
            this.closeSession(hibernateSession);
        }
        return pojos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> list(String queryPrefix, Object ... args) {
        Session hibernateSession = null;
        List objects = null;
        try {
            hibernateSession = this.getSession();
            Query query = hibernateSession.createQuery(queryPrefix);
            for (int i = 1; i <= args.length; ++i) {
                Object param = args[i - 1];
                query.setParameter(i, param);
            }
            objects = query.list();
        }
        catch (JDBCConnectionException e) {
            e.printStackTrace();
        }
        catch (TransactionException e) {
            e.printStackTrace();
        }
        catch (HibernateException e) {
            e.printStackTrace();
        }
        finally {
            this.closeSession(hibernateSession);
        }
        return objects;
    }

    public int count() {
        return this.list().size();
    }

    protected Session getSession() {
        return this.hibernate.getSession();
    }

    protected void closeSession(Session hibernateSession) {
        this.hibernate.closeSession(hibernateSession);
    }

    public AbstractDao(Class<T> entityClass) {
        this.entityClass = entityClass;
        if (!MyLogger.isEnabled()) {
            MyLogger.setEnabled((boolean)true);
        }
    }
}

