/*
 * Decompiled with CFR 0.152.
 */
package vesso.control;

import java.io.Serializable;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.SessionScoped;
import javax.faces.application.FacesMessage;
import javax.inject.Inject;
import javax.inject.Named;
import vesso.control.JSFUtil;
import vesso.model.dao.DaoUtil;
import vesso.model.dao.entities.CatalogCategory;
import vesso.model.dao.entities.CatalogItem;
import vesso.model.util.MyLogger;
import vesso.util.URLUtil;

@Named
@SessionScoped
public class ProductControl
implements Serializable {
    MyLogger logger = new MyLogger(MyLogger.Tier.CONTROLLER);
    @Inject
    DaoUtil dao;
    private List<CatalogItem> products;
    private CatalogItem selected;
    private CatalogItem toAdd;
    private CatalogItem toUpdate;
    private CatalogItem toRemove;
    private Long productCategoryId;
    private CatalogCategory productsFrom;
    private boolean validImage;

    @PostConstruct
    private void init() {
        this.toAdd = new CatalogItem();
        this.loadProducts();
    }

    public String add() {
        this.logger.log("adicionando produto...");
        if (this.toAdd != null && !this.toAdd.getTitle().equals("") && this.toAdd.getTitle() != null) {
            this.validateImage(this.toAdd.getPhotoUrl());
            if (this.isValidImage()) {
                CatalogCategory cat = (CatalogCategory)this.dao.getCatalogCategoryDao().get((Serializable)this.productCategoryId);
                this.toAdd.setCategory(cat);
                this.dao.getCatalogItemDao().add((Object)this.toAdd);
                this.loadProducts();
                this.toAdd = new CatalogItem();
                JSFUtil.addMesssage((String)"Sucesso!", (String)"Novo produto salvo com sucesso!", (FacesMessage.Severity)FacesMessage.SEVERITY_INFO);
                return "/produtos";
            }
            JSFUtil.addMesssage((String)"Ops!", (String)"URL n\u00e3o corresponde a uma imagem v\u00e1lida!", (FacesMessage.Severity)FacesMessage.SEVERITY_ERROR);
            return "";
        }
        return "";
    }

    public String update() {
        this.logger.log("atualizando produto...");
        if (this.toUpdate != null && !this.toUpdate.getTitle().equals("") && this.toUpdate.getTitle() != null) {
            this.validateImage(this.toUpdate.getPhotoUrl());
            if (!this.isValidImage()) {
                JSFUtil.addMesssage((String)"Ops!", (String)"URL n\u00e3o corresponde a uma imagem v\u00e1lida!", (FacesMessage.Severity)FacesMessage.SEVERITY_ERROR);
                return "";
            }
            CatalogCategory cat = (CatalogCategory)this.dao.getCatalogCategoryDao().get((Serializable)this.productCategoryId);
            this.toUpdate.setCategory(cat);
            this.dao.getCatalogItemDao().update((Object)this.toUpdate);
            this.loadProducts();
            JSFUtil.addMesssage((String)"Sucesso!", (String)"Produto atualizado com sucesso!", (FacesMessage.Severity)FacesMessage.SEVERITY_INFO);
            return "/produtos";
        }
        return "";
    }

    public String remove() {
        this.logger.log("removendo produto...");
        this.dao.getCatalogItemDao().remove((Object)this.toRemove);
        this.loadProducts();
        JSFUtil.addMesssage((String)"Sucesso!", (String)"Produto removido com sucesso!", (FacesMessage.Severity)FacesMessage.SEVERITY_INFO);
        return "/produtos";
    }

    public List<CatalogItem> getProducts() {
        this.loadProducts();
        return this.products;
    }

    private void loadProducts() {
        this.products = this.productsFrom == null ? this.dao.getCatalogItemDao().list() : this.dao.getCatalogItemDao().list(this.productsFrom);
    }

    public CatalogItem getSelected() {
        return this.selected;
    }

    public void setSelected(CatalogItem selected) {
        this.selected = selected;
    }

    public CatalogItem getToAdd() {
        return this.toAdd;
    }

    public void setToAdd(CatalogItem toAdd) {
        this.toAdd = toAdd;
    }

    public CatalogItem getToRemove() {
        return this.toRemove;
    }

    public void setToRemove(CatalogItem toRemove) {
        this.logger.log("chamada para toRemove...");
        this.toRemove = toRemove;
    }

    public CatalogItem getToUpdate() {
        return this.toUpdate;
    }

    public void setToUpdate(CatalogItem toUpdate) {
        this.toUpdate = toUpdate;
    }

    public Long getProductCategoryId() {
        return this.productCategoryId;
    }

    public void setProductCategoryId(Long productCategoryId) {
        this.productCategoryId = productCategoryId;
    }

    public CatalogCategory getProductsFrom() {
        return this.productsFrom;
    }

    public void setProductsFrom(CatalogCategory productsFrom) {
        this.productsFrom = productsFrom;
    }

    public boolean isValidImage() {
        return this.validImage;
    }

    public void validateImage(String url) {
        int responseCode = URLUtil.getPrepResponseCode((String)url);
        this.validImage = responseCode > 0 && responseCode != 404;
    }
}

