/*
 * Decompiled with CFR 0.152.
 */
package vesso.control;

import java.io.Serializable;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.SessionScoped;
import javax.faces.application.FacesMessage;
import javax.inject.Inject;
import javax.inject.Named;
import vesso.control.JSFUtil;
import vesso.model.dao.DaoUtil;
import vesso.model.dao.entities.CatalogCategory;
import vesso.model.util.MyLogger;
import vesso.util.URLUtil;

@Named
@SessionScoped
public class CategoryControl
implements Serializable {
    MyLogger logger = new MyLogger(MyLogger.Tier.CONTROLLER);
    @Inject
    DaoUtil dao;
    private List<CatalogCategory> categories;
    private CatalogCategory selected;
    private CatalogCategory toAdd;
    private CatalogCategory toUpdate;
    private CatalogCategory toRemove;
    private boolean validImage;

    @PostConstruct
    private void init() {
        this.toAdd = new CatalogCategory();
        this.loadCategories();
    }

    public String add() {
        this.logger.log("adicionando categoria...");
        if (this.toAdd != null && !this.toAdd.getTitle().equals("") && this.toAdd.getTitle() != null) {
            this.validateImage(this.toAdd.getPhotoRepresUrl());
            if (this.isValidImage()) {
                this.dao.getCatalogCategoryDao().add((Object)this.toAdd);
                this.loadCategories();
                this.toAdd = new CatalogCategory();
                JSFUtil.addMesssage((String)"Sucesso!", (String)"Novo categoria salvo com sucesso!", (FacesMessage.Severity)FacesMessage.SEVERITY_INFO);
                return "/categorias";
            }
            JSFUtil.addMesssage((String)"Ops!", (String)"URL n\u00e3o corresponde a uma imagem v\u00e1lida!", (FacesMessage.Severity)FacesMessage.SEVERITY_ERROR);
            return "";
        }
        return "";
    }

    public String update() {
        this.logger.log("atualizando categoria...");
        if (this.toUpdate != null && !this.toUpdate.getTitle().equals("") && this.toUpdate.getTitle() != null) {
            this.validateImage(this.toUpdate.getPhotoRepresUrl());
            if (this.isValidImage()) {
                this.dao.getCatalogCategoryDao().update((Object)this.toUpdate);
                this.loadCategories();
                JSFUtil.addMesssage((String)"Sucesso!", (String)"Categoria atualizada com sucesso!", (FacesMessage.Severity)FacesMessage.SEVERITY_INFO);
                return "/categorias";
            }
            JSFUtil.addMesssage((String)"Ops!", (String)"URL n\u00e3o corresponde a uma imagem v\u00e1lida!", (FacesMessage.Severity)FacesMessage.SEVERITY_ERROR);
            return "";
        }
        return "";
    }

    public String remove() {
        this.logger.log("removendo categoria...");
        this.dao.getCatalogCategoryDao().remove((Object)this.toRemove);
        this.loadCategories();
        JSFUtil.addMesssage((String)"Sucesso!", (String)"Categoria removida com sucesso!", (FacesMessage.Severity)FacesMessage.SEVERITY_INFO);
        return "/categorias";
    }

    public List<CatalogCategory> getCategories() {
        this.loadCategories();
        return this.categories;
    }

    private void loadCategories() {
        this.categories = this.dao.getCatalogCategoryDao().list();
    }

    public CatalogCategory getSelected() {
        return this.selected;
    }

    public void setSelected(CatalogCategory selected) {
        this.selected = selected;
    }

    public CatalogCategory getToAdd() {
        return this.toAdd;
    }

    public void setToAdd(CatalogCategory toAdd) {
        this.toAdd = toAdd;
    }

    public CatalogCategory getToRemove() {
        return this.toRemove;
    }

    public void setToRemove(CatalogCategory toRemove) {
        this.logger.log("chamada para toRemove...");
        this.toRemove = toRemove;
    }

    public CatalogCategory getToUpdate() {
        return this.toUpdate;
    }

    public void setToUpdate(CatalogCategory toUpdate) {
        this.toUpdate = toUpdate;
    }

    public boolean isValidImage() {
        return this.validImage;
    }

    public void validateImage(String url) {
        int responseCode = URLUtil.getPrepResponseCode((String)url);
        this.validImage = responseCode > 0 && responseCode != 404;
    }
}

